<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormGAds;

class GAdsConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'tracking_id' => (string)$config_values[$form_id.'_tracking_id'],
            'merchant_id' => (string)$config_values[$form_id.'_merchant_id'],
            'conversion_labels' => [
                /* todo: -- Coming soon feature --
                    'phone' => (string)$config_values[$form_id.'_phone_conversion'],
                    'newsletter' => (string)$config_values[$form_id.'_newsletter_conversion'],
                */
                'create_account' => (string)$config_values[$form_id.'_create_account_conversion'],
                'product_view' => (string)$config_values[$form_id.'_product_view_conversion'],
                'add_to_cart' => (string)$config_values[$form_id.'_add_cart_conversion'],
                'begin_checkout' => (string)$config_values[$form_id.'_begin_checkout_conversion'],
                'purchase' => (string)$config_values[$form_id.'_purchase_conversion']
            ]
        ];
    }

    /**
     * @return FormGAds
     */
    protected function getFormComponent(): FormGAds
    {
        return new FormGAds($this->module);
    }
}
