<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormFacebook;

class FacebookConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'tracking_id' => (string)$config_values[$form_id.'_tracking_id'],
            'feed_prefix' => $this->getFeedPrefixNormalized($config_values[$form_id.'_feed_prefix']),
            'feed_variant' => (string)$config_values[$form_id.'_feed_variant']
        ];
    }

    /**
     * @return FormFacebook
     */
    protected function getFormComponent(): FormFacebook
    {
        return new FormFacebook($this->module);
    }
}
