<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use Configuration;
use ReactionCode\RCPGTagManager\DataModel\Category\CategoryModelPresenter;
use ReactionCode\RCPGTagManager\PSModule\DataModelHandler\DataModelHandlerInterface;
use ReactionCode\RCPGTagManager\DataModel\User\UserModelPresenter;
use Tools;

class ContextConfigurator extends AbstractConfigurator
{
    /**
     * @var DataModelHandlerInterface
     */
    protected $data_model_service;

    public function setConfiguration()
    {
        $this->data_model_service = $this->module->getServiceProvider()->getDataModelService();

        $this->configuration = [
            'browser' => $this->getBrowserData(),
            'localization' => $this->getLocalizationData(),
            'page' => $this->getPageData(),
            'shop' => $this->getShopData(),
            'tracking_module' => $this->getModuleData(),
            'user' => $this->getUserData()
        ];
    }

    /**
     * @return array
     */
    private function getBrowserData(): array
    {
        return [
            'device_type' => $this->context->getDevice()
        ];
    }

    /**
     * @return array
     */
    private function getLocalizationData(): array
    {
        return [
            'id_country' => $this->context->country->id,
            'country_code' => $this->context->country->iso_code,
            'id_currency' => $this->context->currency->id,
            'currency_code' => $this->context->currency->iso_code,
            'id_lang' => $this->context->language->id,
            'lang_code' => $this->context->language->iso_code
        ];
    }

    /**
     * @return array
     */
    private function getPageData(): array
    {
        return [
            'controller_name' => Tools::getValue('controller'),
            'products_per_page' => (int)Configuration::get('PS_PRODUCTS_PER_PAGE'),
            'category' => $this->getCategoryData(),
            'search_term' => $this->data_model_service->buildSearchModel()->getSearchTerm()
        ];
    }

    /**
     * @return array
     */
    private function getCategoryData(): array
    {
        $data = [];
        $id_category = Tools::getValue('id_category', 0);

        if (!empty($id_category)) {
            $category_Model = $this->data_model_service->buildCategoryModel(
                $id_category,
                $this->context->language->id
            );
            $presenter = new CategoryModelPresenter($category_Model);
            $data = $presenter->getModel();
        }

        return $data;
    }

    /**
     * @return array
     */
    private function getShopData(): array
    {
        return [
            'id_shop' => (int)$this->context->shop->id,
            'shop_name' => $this->context->shop->name,
        ];
    }

    /**
     * @return array
     */
    private function getModuleData(): array
    {
        $token = $this->module->getServiceProvider()->getTokenService();
        return [
            'module_name' => $this->module->name,
            'checkout_module' => $this->getCheckoutModule(),
            'service_version' => $this->module->getServiceVersion(),
            'token' => $token->getPublicToken()
        ];
    }

    /**
     * @return array
     */
    private function getCheckoutModule(): array
    {
        return $this->module->getServiceProvider()->getModuleDetectorService()->getCheckoutModule();
    }

    /**
     * @return array
     */
    private function getUserData(): array
    {
        $model = $this->data_model_service->buildUserModel();
        $presenter = new UserModelPresenter($model);
        return $presenter->getModel();
    }
}
