<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormCheckout;

class CheckoutConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $form_id = $form_component::FORM_ID;

        $this->configuration = [
            'invalid_order_statuses' => $config_values[$form_id.'_invalid_order_status'],
            'refund_order_statuses' => $config_values[$form_id.'_refund_order_status']
        ];
    }

    protected function getFormComponent(): FormCheckout
    {
        return new FormCheckout($this->module);
    }
}
