<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use Context;
use Module;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;
use Tools;

abstract class AbstractConfigurator
{
    /**
     * @var Module & RCTrackingModuleInterface
     */
    protected $module;

    /**
     * @var int|null
     */
    protected $id_shop;

    /**
     * @var Context
     */
    protected $context;

    /**
     * @var array
     */
    protected $configuration = [];

    public function __construct(RCTrackingModuleInterface $module, int $id_shop = null)
    {
        $this->module = $module;
        $this->id_shop = $id_shop;
        $this->context = Context::getContext();
        $this->setConfiguration();
    }

    /**
     * @return array
     */
    public function getConfiguration(): array
    {
        return $this->configuration;
    }

    abstract protected function setConfiguration();

    protected function getFeedPrefixNormalized($string = '')
    {
        $lang_iso = $this->context->language->iso_code;
        $country_iso = $this->context->country->iso_code;

        $search = [
            '{lang}',
            '{LANG}',
            '{country}',
            '{COUNTRY}'
        ];

        $replace = [
            Tools::strtolower($lang_iso),
            Tools::strtoupper($lang_iso),
            Tools::strtolower($country_iso),
            Tools::strtoupper($country_iso)
        ];

        return str_replace($search, $replace, $string);
    }
}
