<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Configurator\Components;

use ReactionCode\RCPGTagManager\PSModule\Form\Section\FormAPICommon;

class APICommonConfigurator extends AbstractConfigurator
{
    protected function setConfiguration()
    {
        $form_component = $this->getFormComponent();
        $config_values = $form_component->getModelValues($this->id_shop);

        $this->configuration = [
            'campaign_timeout' => $config_values['api_common_campaign_timeout'],
            'referral_exclusion_list' => $config_values['api_common_referral_exclusion_list']
        ];
    }

    /**
     * @return FormAPICommon
     */
    protected function getFormComponent(): FormAPICommon
    {
        return new FormAPICommon($this->module);
    }
}
