<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule\Adapter\Product;

use Product;

abstract class AbstractProductAdapter implements ProductAdapterInterface
{
    /**
     * @var string[][]
     */
    protected $fields = [
        // from product object
        ['id', 'id_product'],
        ['cache_default_attribute', 'id_product_attribute'],
        // from ajax requests
        ['idProduct', 'id_product'],
        ['idProductAttribute', 'id_product_attribute'],
        // from checkout
        ['product_id', 'id_product'],
        ['product_attribute_id', 'id_product_attribute'],
        ['product_quantity', 'quantity'],
        ['product_quantity_refunded', 'quantity_refunded'],
        // from cart
        ['price_with_reduction', 'price'],
        ['price_with_reduction_without_tax', 'price_tax_excl'],
        ['price_without_reduction', 'price_old'],
        ['price_without_reduction_without_tax', 'price_old_tax_excl'],
        ['unit_price_tax_incl', 'price'],
        ['unit_price_tax_excl', 'price_tax_excl']
    ];

    /**
     * @param mixed $product
     * @return array
     */
    public function normalizeProduct($product): array
    {
        $product = $this->normalizeObject($product);
        return $this->normalizeFields($product);
    }

    /**
     * @param mixed $product
     * @return array
     */
    private function normalizeObject($product): array
    {
        if (is_object($product)) {
            if ($product instanceof Product) {
                $product = get_object_vars($product);
            }

            if (method_exists($product, 'jsonSerialize')) {
                $product = $product->jsonSerialize();
            }
        }

        return $product;
    }

    /**
     * @param $product
     * @return array
     */
    private function normalizeFields($product): array
    {
        foreach ($this->fields as $fields) {
            $search_field = $fields[0];
            $add_field = $fields[1];
            if (isset($product[$search_field])) {
                $product[$add_field] = $product[$search_field];
            }
        }
        return $product;
    }
}
