<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\PSModule;

use ReactionCode\RCPGTagManager\PSModule\Configurator\ConfiguratorFactory;
use ReactionCode\RCPGTagManager\PSModule\Configurator\ConfiguratorFactoryInterface;

abstract class AbstractModuleServiceFactory implements ModuleServiceFactoryInterface
{
    /**
     * @var RCTrackingModuleInterface
     */
    protected $module;

    /**
     * @var array
     */
    protected $services = [];

    public function __construct(RCTrackingModuleInterface $module)
    {
        $this->module = $module;
    }

    /**
     * @return ConfiguratorFactoryInterface
     */
    public function getConfiguratorService(): ConfiguratorFactoryInterface
    {
        if (empty($this->services['configurator'])) {
            $this->services['configurator'] = new ConfiguratorFactory($this->module);
        }
        return $this->services['configurator'];
    }
}
