<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\User;

use ReactionCode\RCPGTagManager\DataModel\ModelPresenterInterface;

class UserModelPresenter implements ModelPresenterInterface
{
    /**
     * @var array
     */
    private $model = [];

    /**
     * @var UserModel
     */
    private $user_model;

    public function __construct(UserModel $user_model)
    {
        $this->user_model = $user_model;
        if ($user_model->getIdUser()) {
            $this->setModel();
        }
    }

    public function setModel()
    {
        $this->model['id_user'] = $this->user_model->getIdUser();
        $this->model['id_gender'] = $this->user_model->getIdGender();
        $this->model['id_default_group'] = $this->user_model->getIdDefaultGroup();
        $this->model['birthday'] = $this->user_model->getBirthday();
        $this->model['first_name'] = $this->user_model->getFirstName();
        $this->model['last_name'] = $this->user_model->getLastName();
        $this->model['email'] = $this->user_model->getEmail();
        $this->model['is_guest'] = $this->user_model->getIsGuest();
        $this->model['is_new_login'] = $this->user_model->getIsNewLogin();
        $this->model['is_new_account'] = $this->user_model->getIsNewAccount();
        $this->model['is_newsletter'] = $this->user_model->getIsNewsletter();
        $this->model['is_opt_in'] = $this->user_model->getIsOptIn();

        $this->setGroupModelList();
        $this->setAddressModel();
        $this->setStatsModel();
    }

    private function setGroupModelList()
    {
        $group_model_list = $this->user_model->getGroupModelList()->getList();

        foreach ($group_model_list as $group_model) {
            $this->model['groups'][] = [
                'id_group' => $group_model->getId(),
                'name' => $group_model->getName()
            ];
        }
    }

    private function setAddressModel()
    {
        $address = $this->user_model->getAddressModel();
        $this->model['address'] = [
            'address_1' => $address->getAddress1(),
            'address_2' => $address->getAddress2(),
            'city' => $address->getCity(),
            'company' => $address->getCompany(),
            'country' => $address->getCountry(),
            'country_code' => $address->getCountryCode(),
            'phone' => $address->getPhone(),
            'post_code'=> $address->getPostCode(),
            'state' => $address->getState(),
            'state_code' => $address->getStateCode(),
        ];
    }

    private function setStatsModel()
    {
        $stats = $this->user_model->getStatsModel();
        $this->model['stats'] = [
            'orders_placed' => $stats->getOrdersPlaced(),
            'total_spent' => $stats->getTotalSpent()
        ];
    }

    /**
     * @return array
     */
    public function getModel(): array
    {
        return $this->model;
    }
}
