<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\User;

class UserModel
{
    /**
     * @var int | null
     */
    protected $id_user;

    /**
     * @var int | null
     */
    protected $id_gender;

    /**
     * @var int | null
     */
    protected $id_default_group;

    /**
     * @var int | null
     */
    protected $birthday;

    /**
     * @var string
     */
    protected $first_name = '';

    /**
     * @var string
     */
    protected $last_name = '';

    /**
     * @var string
     */
    protected $email = '';

    /**
     * @var GroupModelList
     */
    protected $group_model_list;

    /**
     * @var bool
     */
    protected $is_new_customer = false;

    /**
     * @var bool
     */
    protected $is_guest = false;

    /**
     * @var bool
     */
    protected $is_new_login = false;

    /**
     * @var bool
     */
    protected $is_new_account = false;

    /**
     * @var bool
     */
    protected $is_newsletter = false;

    /**
     * @var bool
     */
    protected $is_opt_in = false;

    /**
     * @var AddressModel
     */
    protected $address_model;

    /**
     * @var StatsModel
     */
    protected $stats_model;

    public function __construct()
    {
        $this->group_model_list = new GroupModelList();
        $this->address_model = new AddressModel();
        $this->stats_model = new StatsModel();
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     */
    public function setEmail(string $email)
    {
        $this->email = $email;
    }

    /**
     * @return string
     */
    public function getFirstName(): string
    {
        return $this->first_name;
    }

    /**
     * @param string $first_name
     */
    public function setFirstName(string $first_name)
    {
        $this->first_name = $first_name;
    }

    /**
     * @return int | null
     */
    public function getIdGender(): ?int
    {
        return $this->id_gender;
    }

    /**
     * @param int $id_gender
     */
    public function setIdGender(int $id_gender)
    {
        $this->id_gender = $id_gender;
    }

    /**
     * @return int | null
     */
    public function getIdDefaultGroup(): ?int
    {
        return $this->id_default_group;
    }

    /**
     * @param int $id_default_group
     */
    public function setIdDefaultGroup(int $id_default_group)
    {
        $this->id_default_group = $id_default_group;
    }

    /**
     * @return GroupModelList
     */
    public function getGroupModelList(): GroupModelList
    {
        return $this->group_model_list;
    }

    /**
     * @return string
     */
    public function getLastName(): string
    {
        return $this->last_name;
    }

    /**
     * @param string $last_name
     */
    public function setLastName(string $last_name)
    {
        $this->last_name = $last_name;
    }

    /**
     * @return int | null
     */
    public function getIdUser(): ?int
    {
        return $this->id_user;
    }

    /**
     * @param int $id_user
     */
    public function setIdUser(int $id_user)
    {
        $this->id_user = $id_user;
    }

    /**
     * @return bool
     */
    public function getIsGuest(): bool
    {
        return $this->is_guest;
    }

    /**
     * @param bool $is_guest
     */
    public function setIsGuest(bool $is_guest)
    {
        $this->is_guest = $is_guest;
    }

    /**
     * @return bool
     */
    public function getIsNewLogin(): bool
    {
        return $this->is_new_login;
    }

    /**
     * @param bool $is_new_login
     */
    public function setIsNewLogin(bool $is_new_login)
    {
        $this->is_new_login = $is_new_login;
    }

    /**
     * @return bool
     */
    public function getIsNewAccount(): bool
    {
        return $this->is_new_account;
    }

    /**
     * @param bool $is_new_account
     */
    public function setIsNewAccount(bool $is_new_account)
    {
        $this->is_new_account = $is_new_account;
    }

    /**
     * @return bool
     */
    public function getIsOptIn(): bool
    {
        return $this->is_opt_in;
    }

    /**
     * @param bool $is_opt_in
     */
    public function setIsOptIn(bool $is_opt_in)
    {
        $this->is_opt_in = $is_opt_in;
    }

    /**
     * @return bool
     */
    public function getIsNewsletter(): bool
    {
        return $this->is_newsletter;
    }

    /**
     * @param bool $is_newsletter
     */
    public function setIsNewsletter(bool $is_newsletter)
    {
        $this->is_newsletter = $is_newsletter;
    }

    /**
     * @return bool
     */
    public function getIsNewCustomer(): bool
    {
        return $this->is_new_customer;
    }

    /**
     * @param bool $is_new_customer
     */
    public function setIsNewCustomer(bool $is_new_customer)
    {
        $this->is_new_customer = $is_new_customer;
    }

    /**
     * @return AddressModel
     */
    public function getAddressModel(): AddressModel
    {
        return $this->address_model;
    }

    /**
     * @return int | null
     */
    public function getBirthday(): ?int
    {
        return $this->birthday;
    }

    /**
     * @param int $birthday
     */
    public function setBirthday(int $birthday)
    {
        $this->birthday = $birthday;
    }

    /**
     * @return StatsModel
     */
    public function getStatsModel(): StatsModel
    {
        return $this->stats_model;
    }
}
