<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\URL;

class URLModel implements URLInterface
{
    /**
     * @var string
     */
    protected $source_url = '';
    /**
     * @var string
     */
    protected $host = '';

    /**
     * @var string[]
     */
    protected $queries = [];

    public function setURL(string $source_url = '')
    {
        if (!empty($source_url)) {
            $url = parse_url($source_url);
            if (is_array($url)) {
                $this->source_url = $source_url;
                if (!empty($url['host'])) {
                    $this->host = $url['host'];
                }
                if (!empty($url['query'])) {
                    $this->setQuery($url['query']);
                }
            }
        }
    }

    /**
     * @param string $query_string
     */
    private function setQuery(string $query_string)
    {
        $query_array = [];
        parse_str($query_string, $query_array);
        if (!empty($query_array)) {
            $this->queries = $query_array;
        }
    }

    /**
     * @return string
     */
    public function getSourceUrl(): string
    {
        return $this->source_url;
    }

    /**
     * @return string
     */
    public function getHost(): string
    {
        return $this->host;
    }

    /**
     * @return string[]
     */
    public function getParams(): array
    {
        return $this->queries;
    }
}
