<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Product;

use ReactionCode\RCPGTagManager\DataModel\ModelPresenterInterface;

class ProductModelPresenter implements ModelPresenterInterface
{
    /**
     * @var array
     */
    private $model;

    /**
     * @var ProductModel
     */
    private $product_model;

    public function __construct(ProductModel $product_model)
    {
        $this->product_model = $product_model;

        $this->setCommonData();

        if ($product_model->getQuantity() === null) {
            $this->setDetailData();
        } else {
            $this->setCartData();
        }
    }

    private function setCommonData()
    {
        $this->model = [
            'id_index' => $this->product_model->getIdIndex(),
            'id_product' => $this->product_model->getIdProduct(),
            'id_attribute' => $this->product_model->getIdAttribute(),
            'id_lang' => $this->product_model->getIdLang()
        ];
    }

    private function setDetailData()
    {
        $this->setCategoryData();
        $this->model['name'] = $this->product_model->getName();
        $this->model['attributes'] = $this->product_model->getAttributes();

        $this->model['id_manufacturer'] = $this->product_model->getIdManufacturer();
        $this->model['manufacturer_name'] = $this->product_model->getManufacturerName();

        $this->setPriceData();
        $this->model['price_old'] = $this->product_model->getPriceOld();
        $this->model['price_old_tax_excl'] = $this->product_model->getPriceOldTaxExcl();

        $this->model['is_available'] = $this->product_model->getIsAvailable();
        $this->model['condition'] = $this->product_model->getCondition();

        $this->model['ean'] = $this->product_model->getEan();
        $this->model['upc'] = $this->product_model->getUpc();
        $this->model['reference'] = $this->product_model->getReference();
    }

    private function setCartData()
    {
        $this->setPriceData();
        $this->model['quantity'] = $this->product_model->getQuantity();
    }

    private function setCategoryData()
    {
        $category_model = $this->product_model->getCategoryModel();
        $this->model['id_category'] = $category_model->getIdCategory();
        $this->model['category_path'] = $category_model->getPath();
    }

    private function setPriceData()
    {
        $this->model['price'] = $this->product_model->getPrice();
        $this->model['price_tax_excl'] = $this->product_model->getPriceTaxExcl();
    }

    /**
     * @return array
     */
    public function getModel(): array
    {
        return $this->model;
    }
}
