<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Product;

class ProductModelList implements ProductModelListInterface
{
    /**
     * @var ProductModel[]
     */
    private $list = [];

    /**
     * @inheritDoc
     */
    public function addProduct(ProductModel $product_model)
    {
        if ($product_model->getIdIndex()) {
            $this->list[] = $product_model;
        }
    }

    /**
     * @inheritDoc
     */
    public function getList(): array
    {
        return $this->list;
    }

    /**
     * @inheritDoc
     */
    public function getPresentedList(): array
    {
        return array_map([$this, 'presentProductModel'], $this->list);
    }

    /**
     * @param ProductModel $product_model
     * @return array
     */
    private function presentProductModel(ProductModel $product_model): array
    {
        $presenter = new ProductModelPresenter($product_model);
        return $presenter->getModel();
    }
}
