<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Product;

use ReactionCode\RCPGTagManager\DataModel\Category\CategoryModel;

class ProductModel
{
    const INDEX_PIPE = '-';

    /**
     * @var int | null
     */
    protected $id_index;
    /**
     * @var int | null
     */
    protected $id_product;
    /**
     * @var int | null
     */
    protected $id_attribute;
    /**
     * @var int | null
     */
    protected $id_lang;
    /**
     * @var string | null
     */
    protected $name;

    /**
     * @var string[][]
     */
    protected $attributes = [];
    /**
     * @var CategoryModel
     */
    protected $category_model;

    /**
     * @var int | null
     */
    protected $id_manufacturer;
    /**
     * @var string | null
     */
    protected $manufacturer_name;
    /**
     * @var bool
     */
    protected $is_available = false;
    /**
     * @var string | null
     */
    protected $ean;
    /**
     * @var string | null
     */
    protected $upc;
    /**
     * @var string | null
     */
    protected $reference;
    /**
     * @var string | null
     */
    protected $condition;

    /**
     * @var int | null
     */
    protected $quantity;

    /**
     * @var float | null
     */
    protected $price_old;
    /**
     * @var float | null
     */
    protected $price_old_tax_excl;
    /**
     * @var float | null
     */
    protected $price;
    /**
     * @var float | null
     */
    protected $price_tax_excl;

    public function __construct(int $id_product, int $id_product_attribute, int $id_lang)
    {
        $this->category_model = new CategoryModel();
        $this->id_product = $id_product;
        $this->id_attribute = $id_product_attribute;
        $this->id_lang = $id_lang;
        $this->setIdIndex();
    }

    /**
     * @return string | null
     */
    public function getIdIndex(): ?string
    {
        return $this->id_index;
    }

    private function setIdIndex()
    {
        $this->id_index = $this->id_product .
            self::INDEX_PIPE .
            $this->id_attribute .
            self::INDEX_PIPE .
            $this->id_lang;
    }

    /**
     * @return int | null
     */
    public function getIdProduct(): ?int
    {
        return $this->id_product;
    }

    /**
     * @return int | null
     */
    public function getIdAttribute(): ?int
    {
        return $this->id_attribute;
    }

    /**
     * @return int | null
     */
    public function getIdLang(): ?int
    {
        return $this->id_lang;
    }

    /**
     * @return string | null
     */
    public function getName(): ?string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name)
    {
        $this->name = $name;
    }

    /**
     * @return string | null[][]
     */
    public function getAttributes(): ?array
    {
        return $this->attributes;
    }

    /**
     * @param string[][] $attributes
     */
    public function setAttributes(array $attributes)
    {
        $this->attributes = $attributes;
    }

    /**
     * @return CategoryModel
     */
    public function getCategoryModel(): CategoryModel
    {
        return $this->category_model;
    }

    /**
     * @return int | null
     */
    public function getIdManufacturer(): ?int
    {
        return $this->id_manufacturer;
    }

    /**
     * @param int $id_manufacturer
     */
    public function setIdManufacturer(int $id_manufacturer)
    {
        $this->id_manufacturer = $id_manufacturer;
    }

    /**
     * @return string | null
     */
    public function getManufacturerName(): ?string
    {
        return $this->manufacturer_name;
    }

    /**
     * @param string $manufacturer_name
     */
    public function setManufacturerName(string $manufacturer_name)
    {
        $this->manufacturer_name = $manufacturer_name;
    }

    /**
     * @return bool
     */
    public function getIsAvailable(): bool
    {
        return $this->is_available;
    }

    /**
     * @param bool $is_available
     */
    public function setIsAvailable(bool $is_available)
    {
        $this->is_available = $is_available;
    }

    /**
     * @return string | null
     */
    public function getEan(): ?string
    {
        return $this->ean;
    }

    /**
     * @param string $ean
     */
    public function setEan(string $ean)
    {
        $this->ean = $ean;
    }

    /**
     * @return string | null
     */
    public function getUpc(): ?string
    {
        return $this->upc;
    }

    /**
     * @param string $upc
     */
    public function setUpc(string $upc)
    {
        $this->upc = $upc;
    }

    /**
     * @return string | null
     */
    public function getReference(): ?string
    {
        return $this->reference;
    }

    /**
     * @param string $reference
     */
    public function setReference(string $reference)
    {
        $this->reference = $reference;
    }

    /**
     * @return string | null
     */
    public function getCondition(): ?string
    {
        return $this->condition;
    }

    /**
     * @param string $condition
     */
    public function setCondition(string $condition)
    {
        $this->condition = $condition;
    }

    /**
     * @return int | null
     */
    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     */
    public function setQuantity(int $quantity)
    {
        $this->quantity = $quantity;
    }


    /**
     * @return float | null
     */
    public function getPriceOld(): ?float
    {
        return $this->price_old;
    }

    /**
     * @param float $price_old
     */
    public function setPriceOld(float $price_old)
    {
        $this->price_old = $price_old;
    }

    /**
     * @return float | null
     */
    public function getPriceOldTaxExcl(): ?float
    {
        return $this->price_old_tax_excl;
    }

    /**
     * @param float $price_old_tax_excl
     */
    public function setPriceOldTaxExcl(float $price_old_tax_excl)
    {
        $this->price_old_tax_excl = $price_old_tax_excl;
    }

    /**
     * @return float | null
     */
    public function getPrice(): ?float
    {
        return $this->price;
    }

    /**
     * @param float $price
     */
    public function setPrice(float $price)
    {
        $this->price = $price;
    }

    /**
     * @return float | null
     */
    public function getPriceTaxExcl(): ?float
    {
        return $this->price_tax_excl;
    }

    /**
     * @param float $price_tax_excl
     */
    public function setPriceTaxExcl(float $price_tax_excl)
    {
        $this->price_tax_excl = $price_tax_excl;
    }
}
