<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Order;

class TotalAmountsOrderModel
{
    /**
     * @var float | null
     */
    private $total_products_tax_excl;
    /**
     * @var float | null
     */
    private $total_revenue_tax_excl;
    /**
     * @var float | null
     */
    private $total_shipping_tax_excl;
    /**
     * @var float | null
     */
    private $total_tax;
    /**
     * @var float | null
     */
    private $total_wrapping_tax_excl;
    /**
     * @var float | null
     */
    private $total_revenue;
    /**
     * @var float | null
     */
    private $total_shipping;
    /**
     * @var float | null
     */
    private $total_wrapping;
    /**
     * @var float | null
     */
    private $total_products;
    /**
     * @var float | null
     */
    private $total_discounts;
    /**
     * @var float | null
     */
    private $total_discounts_tax_excl;

    /**
     * @return float|null
     */
    public function getTotalProductsTaxExcl(): ?float
    {
        return $this->total_products_tax_excl;
    }

    /**
     * @param float $total_revenue_tax_excl
     */
    public function setTotalRevenueTaxExcl(float $total_revenue_tax_excl): void
    {
        $this->total_revenue_tax_excl = $total_revenue_tax_excl;
    }

    /**
     * @param float $total_discounts_tax_excl
     */
    public function setTotalDiscountsTaxExcl(float $total_discounts_tax_excl): void
    {
        $this->total_discounts_tax_excl = $total_discounts_tax_excl;
    }

    /**
     * @return float | null
     */
    public function getTotalShipping(): ?float
    {
        return $this->total_shipping;
    }

    /**
     * @return float | null
     */
    public function getTotalProducts(): ?float
    {
        return $this->total_products;
    }

    /**
     * @param float $total_products
     */
    public function setTotalProducts(float $total_products): void
    {
        $this->total_products = $total_products;
    }

    /**
     * @param float $total_products_tax_excl
     */
    public function setTotalProductsTaxExcl(float $total_products_tax_excl): void
    {
        $this->total_products_tax_excl = $total_products_tax_excl;
    }

    /**
     * @param float $total_tax
     */
    public function setTotalTax(float $total_tax): void
    {
        $this->total_tax = $total_tax;
    }

    /**
     * @return float | null
     */
    public function getTotalDiscountsTaxExcl(): ?float
    {
        return $this->total_discounts_tax_excl;
    }

    /**
     * @param float $total_wrapping_tax_excl
     */
    public function setTotalWrappingTaxExcl(float $total_wrapping_tax_excl): void
    {
        $this->total_wrapping_tax_excl = $total_wrapping_tax_excl;
    }

    /**
     * @param float $total_wrapping
     */
    public function setTotalWrapping(float $total_wrapping): void
    {
        $this->total_wrapping = $total_wrapping;
    }

    /**
     * @return float | null
     */
    public function getTotalWrappingTaxExcl(): ?float
    {
        return $this->total_wrapping_tax_excl;
    }

    /**
     * @return float | null
     */
    public function getTotalTax(): ?float
    {
        return $this->total_tax;
    }

    /**
     * @return float | null
     */
    public function getTotalDiscounts(): ?float
    {
        return $this->total_discounts;
    }

    /**
     * @return float | null
     */
    public function getTotalShippingTaxExcl(): ?float
    {
        return $this->total_shipping_tax_excl;
    }

    /**
     * @param float $total_revenue
     */
    public function setTotalRevenue(float $total_revenue): void
    {
        $this->total_revenue = $total_revenue;
    }

    /**
     * @return float | null
     */
    public function getTotalWrapping(): ?float
    {
        return $this->total_wrapping;
    }

    /**
     * @return float | null
     */
    public function getTotalRevenueTaxExcl(): ?float
    {
        return $this->total_revenue_tax_excl;
    }

    /**
     * @param float $total_discounts
     */
    public function setTotalDiscounts(float $total_discounts): void
    {
        $this->total_discounts = $total_discounts;
    }

    /**
     * @param float $total_shipping_tax_excl
     */
    public function setTotalShippingTaxExcl(float $total_shipping_tax_excl): void
    {
        $this->total_shipping_tax_excl = $total_shipping_tax_excl;
    }

    /**
     * @return float | null
     */
    public function getTotalRevenue(): ?float
    {
        return $this->total_revenue;
    }

    /**
     * @param float $total_shipping
     */
    public function setTotalShipping(float $total_shipping): void
    {
        $this->total_shipping = $total_shipping;
    }
}
