<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Order;

use ReactionCode\RCPGTagManager\DataModel\ModelPresenterInterface;

class OrderModelPresenter implements ModelPresenterInterface
{
    /**
     * @var array
     */
    private $model;

    /**
     * @var OrderModel
     */
    private $order_model;

    public function __construct(OrderModel $order_model)
    {
        $this->order_model = $order_model;
        $this->setOrderData();
    }

    private function setOrderData()
    {
        $this->model = [
            'id' => $this->order_model->getId(),
            'id_customer' => $this->order_model->getIdCustomer(),
            'id_lang' => $this->order_model->getIdLang(),
            'id_shop' => $this->order_model->getIdShop(),
            'carrier_name' => $this->order_model->getCarrierName(),
            'coupons' => $this->order_model->getCoupons(),
            'currency_iso' => $this->order_model->getCurrencyCode(),
            'date_add' => $this->order_model->getDateAdd(),
            'payment_module' => $this->order_model->getPaymentModule(),
            'payment_name' => $this->order_model->getPaymentName(),
            'total_amounts' => $this->getTotalAmounts()
        ];
    }

    private function getTotalAmounts(): array
    {
        $total_amounts = $this->order_model->getTotalAmounts();

        return [
            'tax' => $total_amounts->getTotalTax(),
            'revenue' => $total_amounts->getTotalRevenue(),
            'revenue_tax_excl' => $total_amounts->getTotalRevenueTaxExcl(),
            'products' => $total_amounts->getTotalProducts(),
            'products_tax_excl' => $total_amounts->getTotalProductsTaxExcl(),
            'shipping' => $total_amounts->getTotalShipping(),
            'shipping_tax_excl' => $total_amounts->getTotalShippingTaxExcl(),
            'wrapping' => $total_amounts->getTotalWrapping(),
            'wrapping_tax_excl' => $total_amounts->getTotalWrappingTaxExcl(),
            'discounts' => $total_amounts->getTotalDiscounts(),
            'discounts_tax_excl' => $total_amounts->getTotalDiscountsTaxExcl()
        ];
    }

    /**
     * @inheritDoc
     */
    public function getModel(): array
    {
        return $this->model;
    }
}
