<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Order;

class OrderModel
{
    /**
     * @var int | null
     */
    private $id;

    /**
     * @var int | null
     */
    private $id_customer;

    /**
     * @var int | null
     */
    private $id_lang;

    /**
     * @var int | null
     */
    private $id_shop;

    /**
     * @var string | null
     */
    private $carrier_name;

    /**
     * @var string[]
     */
    private $coupons;

    /**
     * @var string | null
     */
    private $currency_code;

    /**
     * @var string | null
     */
    private $date_add;

    /**
     * @var string | null
     */
    private $payment_module;

    /**
     * @var string | null
     */
    private $payment_name;

    /**
     * @var TotalAmountsOrderModel
     */
    private $total_amounts;

    public function __construct()
    {
        $this->total_amounts = new TotalAmountsOrderModel();
    }

    /**
     * @return int | null
     */
    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @param int $id
     */
    public function setId(int $id)
    {
        $this->id = $id;
    }

    /**
     * @return int | null
     */
    public function getIdCustomer(): ?int
    {
        return $this->id_customer;
    }

    /**
     * @param int $id_customer
     */
    public function setIdCustomer(int $id_customer)
    {
        $this->id_customer = $id_customer;
    }

    /**
     * @return int | null
     */
    public function getIdLang(): ?int
    {
        return $this->id_lang;
    }

    /**
     * @param int $id_lang
     */
    public function setIdLang(int $id_lang)
    {
        $this->id_lang = $id_lang;
    }

    /**
     * @return int | null
     */
    public function getIdShop(): ?int
    {
        return $this->id_shop;
    }

    /**
     * @param int $id_shop
     */
    public function setIdShop(int $id_shop)
    {
        $this->id_shop = $id_shop;
    }

    /**
     * @return string | null
     */
    public function getCarrierName(): ?string
    {
        return $this->carrier_name;
    }

    /**
     * @param string $carrier_name
     */
    public function setCarrierName(string $carrier_name)
    {
        $this->carrier_name = $carrier_name;
    }

    /**
     * @return string[]
     */
    public function getCoupons(): array
    {
        return $this->coupons;
    }

    /**
     * @param string[] $coupons
     */
    public function setCoupons(array $coupons)
    {
        $this->coupons = $coupons;
    }

    /**
     * @return string | null
     */
    public function getCurrencyCode(): ?string
    {
        return $this->currency_code;
    }

    /**
     * @param string $currency_code
     */
    public function setCurrencyCode(string $currency_code)
    {
        $this->currency_code = $currency_code;
    }

    /**
     * @return string | null
     */
    public function getDateAdd(): ?string
    {
        return $this->date_add;
    }

    /**
     * @param string $date_add
     */
    public function setDateAdd(string $date_add)
    {
        $this->date_add = $date_add;
    }

    /**
     * @return string | null
     */
    public function getPaymentModule(): ?string
    {
        return $this->payment_module;
    }

    /**
     * @param string $payment_module
     */
    public function setPaymentModule(string $payment_module)
    {
        $this->payment_module = $payment_module;
    }

    /**
     * @return string | null
     */
    public function getPaymentName(): ?string
    {
        return $this->payment_name;
    }

    /**
     * @param string $payment_name
     */
    public function setPaymentName(string $payment_name)
    {
        $this->payment_name = $payment_name;
    }

    /**
     * @return TotalAmountsOrderModel
     */
    public function getTotalAmounts(): TotalAmountsOrderModel
    {
        return $this->total_amounts;
    }
}
