<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Connections;

use ReactionCode\RCPGTagManager\DataModel\URL\URLInterface;
use ReactionCode\RCPGTagManager\DataModel\URL\URLModel;

class ConnectionsModel
{
    /**
     * @var URLInterface
     */
    public $referrer;

    /**
     * @var URLInterface
     */
    public $landing;

    /**
     * @var string[]
     */
    public $keywords = [];

    public function __construct(array $connections)
    {
        $this->referrer = new URLModel();
        $this->landing = new URLModel();

        if ($this->isValidRequest($connections)) {
            $this->referrer->setURL($connections['http_referer']);
            $this->landing->setURL($connections['request_uri']);
            if (is_array($connections['keywords']) && !empty($connections['keywords'])) {
                $this->keywords = $connections['keywords'];
            }
        }
    }

    private function isValidRequest(array $connections = []): bool
    {
        return isset(
            $connections['http_referer'],
            $connections['request_uri'],
            $connections['keywords']
        ) &&
            !empty($connections['http_referer']) &&
            !empty($connections['request_uri'])
        ;
    }
}
