<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

namespace ReactionCode\RCPGTagManager\DataModel\Category;

use ReactionCode\RCPGTagManager\DataModel\ModelPresenterInterface;

class CategoryModelPresenter implements ModelPresenterInterface
{
    /**
     * @var array
     */
    private $model = [];

    /**
     * @var CategoryModel
     */
    private $category_model;

    public function __construct(CategoryModel $category_model)
    {
        $this->category_model = $category_model;
        $this->setModel();
    }

    private function setModel()
    {
        $path = $this->category_model->getPath();
        $this->model['id_category'] = $this->category_model->getIdCategory();
        $this->model['name'] = $path[count($path)-1];
        $this->model['path'] = $path;
    }

    public function getModel(): array
    {
        return $this->model;
    }
}
