<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(dirname(__FILE__) . '/vendor/autoload.php');

class RCPGTagManager extends Module implements ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface
{
    /**
     * @var bool
     */
    public $bootstrap = true;

    /**
     * @var ReactionCode\RCPGTagManager\PSModule\ModuleServiceFactoryInterface
     */
    private $service_provider;

    /**
     * @var string
     */
    private $service_version;

    /**
     * @var Order | null
     */
    private $currentOrder;

    /**
     * @var ReactionCode\RCPGTagManager\PSModule\Hook\HookFactoryInterface
     */
    protected $hook_service;

    /**
     * @throws Exception
     */
    public function __construct()
    {
        $this->name = 'rcpgtagmanager';
        $this->tab = 'analytics_stats';
        $this->version = '3.1.8';
        $this->displayName = 'Premium Google Tag Manager';
        $this->description = $this->l('One module for rule them all, Google Analytics, Google Ads, Facebook, etc..');
        $this->author = 'ReactionCode';
        $this->author_address = '0xf21e54Ea7B0D8e4413f99D60a3CC1dc49C5ffEf8';
        $this->module_key = '3567cdec5eb216d55117d376f35d57d2';
        $this->ps_versions_compliancy = ['min' => '1.6.1', 'max' => '1.7.99'];
        $this->confirmUninstall = $this->l('Are you sure you want to uninstall?');

        parent::__construct();
        $this->setServiceProviders();
    }

    /**
     * @throws PrestaShopModuleException
     */
    private function setServiceProviders()
    {
        $this->service_version = mb_substr(str_replace('.', '', _PS_VERSION_), 0, 2);
        $this->service_provider = ReactionCode\RCPGTagManager\PSModule\ModuleServiceProvider::getServicePlatform($this);
        $this->hook_service = $this->service_provider->getHookService();
    }

    /**
     * @return bool
     */
    public function isUsingNewTranslationSystem()
    {
        return true;
    }

    /**
     * @return bool
     */
    public function install()
    {
        return (parent::install() && $this->service_provider->getSetupService()->install()) || $this->uninstall();
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
        return $this->service_provider->getSetupService()->uninstall() && parent::uninstall();
    }

    /**
     * @return false|string
     */
    public function getContent()
    {
        try {
            return $this->getModuleContent();
        } catch (Exception $exception) {
            $this->displayError($exception);
        }
        return false;
    }

    /**
     * @return string
     */
    private function getModuleContent()
    {
        return $this->service_provider->getContentService()->getContent();
    }

    /**
     * @return string
     */
    public function getServiceVersion()
    {
        return $this->service_version;
    }

    /**
     * @return ReactionCode\RCPGTagManager\PSModule\ModuleServiceFactoryInterface
     */
    public function getServiceProvider()
    {
        return $this->service_provider;
    }

    public function setCurrentOrder(Order $order)
    {
        $this->currentOrder = $order;
    }

    /**
     * @inheritDoc
     */
    public function getCurrentOrder()
    {
        return $this->currentOrder;
    }

    /**
     * @return mixed
     */
    public function hookActionCustomerAccountAdd()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookActionAuthentication()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookActionValidateOrder($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @return mixed
     */
    public function hookHeader()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookDisplayPaymentReturn($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @return mixed
     */
    public function hookDisplayOrderConfirmation($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @return mixed
     */
    public function hookDisplayFooter()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookDisplayBeforeBodyClosingTag()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookDisplayBackOfficeHeader()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @return mixed
     */
    public function hookDisplayAdminOrderTabOrder()
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec();
    }

    /**
     * @param $params
     * @return mixed
     */
    public function hookDisplayAdminOrderContentOrder($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @param $params
     * @return mixed
     */
    public function hookDisplayAdminOrderTabLink($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @param $params
     * @return mixed
     */
    public function hookDisplayAdminOrderTabContent($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }

    /**
     * @param $params
     * @return mixed
     */
    public function hookActionOrderStatusUpdate($params)
    {
        return $this->hook_service->getHook(__FUNCTION__)->exec($params);
    }
}
