<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L.
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L. It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

use ReactionCode\RCPGTagManager\PSModule\Cron\CronHandler;
use ReactionCode\RCPGTagManager\PSModule\RCTrackingModuleInterface;

final class RcpgtagmanagerCronTaskModuleFrontController extends ModuleFrontController
{
    /**
     * @var array
     */
    private $request_data = [];

    /**
     * @var array
     */
    private $configuration = [];

    public function postProcess()
    {
        try {
            $this->handleRequest();
        } catch (PrestaShopDatabaseException | PrestaShopException $exception) {
            PrestaShopLogger::addLog($exception->getMessage(), 3);
        } catch (Exception $exception) {
            http_response_code($exception->getCode());
        }
        die(1);
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws Exception
     */
    private function handleRequest()
    {
        $this->initRequest();
        if ($this->module instanceof RCTrackingModuleInterface && $this->isValidRequest()) {
            $cron_handler = new CronHandler($this->module);
            $cron_handler->recoverMissingTransactions();
        } else {
            throw new Exception('invalid request', 400);
        }
    }

    private function initRequest()
    {
        $this->setRequestData();
        $this->setCronConfiguration();
    }

    private function setRequestData()
    {
        $this->request_data = [
            'token' => Tools::getValue('token', null)
        ];
    }

    private function setCronConfiguration()
    {
        if ($this->module instanceof RCTrackingModuleInterface) {
            $this->configuration = $this->module
                ->getServiceProvider()
                ->getConfiguratorService()
                ->getCronConfiguration()
            ;
        }
    }

    /**
     * @return bool
     */
    private function isValidRequest()
    {
        return  $this->isValidToken();
    }

    /**
     * @return bool
     */
    private function isValidToken()
    {
        $token_length = 32;

        return !empty($this->configuration['token']) &&
            !empty($this->request_data['token']) &&
            mb_strlen($this->configuration['token']) === $token_length &&
            mb_strlen($this->request_data['token']) === $token_length &&
            $this->configuration['token'] === $this->request_data['token']
        ;
    }
}
