<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

class RCPGTagManagerUserTrackingData extends ObjectModel
{
    /**
     * @var int
     */
    public $id_customer;

    /**
     * @var string
     */
    public $uuid;

    /**
     * @var string
     */
    public $ip;

    /**
     * @var string
     */
    public $tracking_data;

    /**
     * @var string
     */
    public $date_add;

    public static $definition = [
        'table' => 'rcpgtagmanager_user_tracking_data',
        'primary' => 'id_customer',
        'fields' => [
            'id_customer' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true],
            'ip' => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName'],
            'uuid' => ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => true],
            'tracking_data' => ['type' => self::TYPE_STRING, 'validate' => 'isAnything'],
            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'required' => true]
        ]
    ];

    /**
     * @return mixed|void
     */
    public function getTrackingData()
    {
        if (!empty($this->tracking_data)) {
            return json_decode($this->tracking_data, true);
        }
    }

    /**
     * @throws PrestaShopException
     * @throws PrestaShopDatabaseException
     * @throws Exception
     */
    public static function setUserTrackingData(int $id_customer, array $tracking_data = [])
    {
        $user_tracking_data = new self($id_customer);
        $user_tracking_data->id_customer = $id_customer;
        $user_tracking_data->ip = Tools::getRemoteAddr();
        if (empty($user_tracking_data->uuid) || !self::isUUID($user_tracking_data->uuid)) {
            $user_tracking_data->uuid = self::UUID();
        }
        $user_tracking_data->tracking_data = json_encode($tracking_data);
        $user_tracking_data->date_add = date('Y-m-d H:i:s');
        $user_tracking_data->save();
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     * @throws Exception
     */
    public static function getUserTrackingData(int $id_customer)
    {
        $user_tracking_data = new self($id_customer);

        if (empty($user_tracking_data->id)) {
            $user_tracking_data->id_customer = $id_customer;
            $user_tracking_data->uuid = self::UUID();
            $user_tracking_data->save();
        }
        return $user_tracking_data;
    }

    /**
     * @return string
     * @throws Exception
     */
    private static function UUID()
    {
        // Generate 16 bytes (128 bits) of random data
        $data = random_bytes(16);
        // Set version to 0100
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        // Set bits 6-7 to 10
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);

        // Output the 36 character UUID.
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }

    /**
     * @param string $uuid
     * @return bool
     */
    private static function isUUID(string $uuid)
    {
        return preg_match('/^{?[0-9a-f]{8}-?[0-9a-f]{4}-?[0-9a-f]{4}-?'.
                '[0-9a-f]{4}-?[0-9a-f]{12}}?$/i', $uuid) === 1;
    }
}
