<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to a trade license awarded by
 * Garamo Online S.L
 *
 * Any use, public communication, reproduction, modification or
 * distribution of this source file without the written consent of
 * Garamo Online S.L It Is prohibited.
 *
 * @author    ReactionCode <info@reactioncode.com>
 * @copyright Garamo Online S.L 2015-2022.
 * @license   Commercial license
 */

class RCPGTagManagerOrderTrackingStatus extends ObjectModel
{
    const NOT_IN_CONTROL_TABLE = 0;
    const SETUP = 1;
    const WAITING_THANK_YOU_PAGE = 2;
    const CUSTOMER_BROWSER = 3;
    const SERVER_AD_BLOCK = 4;
    const SERVER_ADMIN = 5;
    const SERVER_WEBSERVICE = 6;
    const SERVER_CRON = 7;
    const SERVER_VALID_STATUS = 8;
    const ABORTED_INVALID_STATUS = 9;

    /**
     * @var int
     */
    public $id_order;

    /**
     * @var int
     */
    public $status;

    /**
     * @var string
     */
    public $date_add;

    /**
     * @var array
     */
    public static $definition = [
        'table' => 'rcpgtagmanager_order_tracking_status',
        'primary' => 'id_order',
        'fields' => [
            'id_order' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true],
            'status' => ['type' => self::TYPE_INT, 'validate' => 'isUnsignedId', 'required' => true],
            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate', 'required' => true],
        ]
    ];

    /**
     * @throws PrestaShopException
     * @throws PrestaShopDatabaseException
     */
    public static function setOrderStatus(Order $order, int $status)
    {
        $new_tracking_status = new self($order->id);
        $new_tracking_status->id_order = $order->id;
        $new_tracking_status->status = $status;
        $new_tracking_status->date_add = date('Y-m-d H:i:s');
        $new_tracking_status->save();
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function isPendingTransaction(Order $order)
    {
        $tracking_status = new self($order->id);

        $pending_statuses = [
            self::NOT_IN_CONTROL_TABLE,
            self::WAITING_THANK_YOU_PAGE,
            self::ABORTED_INVALID_STATUS
        ];

        return  in_array((int)$tracking_status->status, $pending_statuses);
    }
}
