<?php
/**
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    Anvanto <anvantoco@gmail.com>
*  @copyright 2022 Anvanto
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

require_once _PS_MODULE_DIR_ . 'an_productextratabs/classes/anProductTabs.php';

class AdminProductTabsController extends ModuleAdminController
{
    protected $_module = null;
    
    protected $position_identifier = 'position';
    protected $_defaultOrderBy = 'position';
    protected $_defaultOrderWay = 'ASC';   
    
    protected $allow_export = true;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->context = Context::getContext();
        $this->table = 'an_productextratabs';
        $this->identifier = 'id_tab';
        $this->className = 'anProductTabs';
        $this->lang = true;

        $this->addRowAction('edit');
        $this->addRowAction('delete');
 
        $this->name = 'AdminProductTabsController';
        
        parent::__construct();
        
        $this->fields_list = [
            'id_tab' => [
                'title' => $this->l('ID'), 
                'width' => 25,
                'search'  => false,
            ],

            'tab_name' => [
                'title' => $this->l('Tab name'), 
                'search'  => false,
            ],                  

            'position' => [
                'title' => $this->l('Position'), 
                'search'  => false,
                'type' => 'position',
            ],            

            'relation' => array(
                'title' => $this->module->l('Relation'), 
                'search'  => false,
                'width' => 150,
            ), 
            
            'combinations' => [
                'title' => $this->l('Show combinations'),
                'width' => 40,
                'active' => 'update',
                'align' => 'center',
                'type' => 'bool',
                'search'  => false,
                'orderby' => false
            ],  

            'active' => [
                'title' => $this->l('Active'),
                'width' => 40,
                'active' => 'update',
                'align' => 'center',
                'type' => 'bool',
                'search'  => false,
                'orderby' => false
            ],          

        ];

        if (Shop::isFeatureActive() && Shop::getContext() != Shop::CONTEXT_ALL) {
            $this->_where .= ' AND a.' . $this->identifier . ' IN (
                SELECT sa.' . $this->identifier . '
                FROM `' . _DB_PREFIX_ . $this->table . '_shop` sa
                WHERE sa.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
            )';
        }
    }

    public function getList($id_lang, $order_by = null, $order_way = null, $start = 0, $limit = null, $id_lang_shop = false)
    {
        parent::getList($id_lang, $order_by, $order_way, $start, $limit, $id_lang_shop);

        foreach ($this->_list as &$list) {

            switch ($list['relation']){
                case 1:
                    $list['relation'] = $this->module->l('Categories');
                    break;        

                case 2:
                    $list['relation'] = $this->module->l('Products');
                    break;    
                    
                default:
                    $list['relation'] = $this->module->l('all');
            }            
        } 
    }    
    
    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJquery();
        $this->js_files[] = _MODULE_DIR_ . 'an_productextratabs/views/js/Sortable.min.js';
        $this->js_files[] = _MODULE_DIR_ . 'an_productextratabs/views/js/sorting.js';
        $this->js_files[] = _MODULE_DIR_ . 'an_productextratabs/views/js/back_tabs.js';
        $this->css_files[_MODULE_DIR_ . 'an_productextratabs/views/css/back.css'] = 'all';
    }    
    
    public function renderList()
    {                    
        return parent::renderList() . $this->getImportForm() . $this->module->topPromo();
    } 

    public function getImportForm()
    {
        $form['form']['legend'] = [
            'title' => $this->l('Import'),
        ];

        $form['form']['input'][] = [
            'type' => 'switch',
            'name' => 'an_del_tabs',
            'label' => $this->l('Remove current tabs before import'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Yes')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('No')
                ]
            ],
        ];  

        $form['form']['input'][] = [
            'type' => 'file',
            'label' => $this->l('Import from JSON'),
            'name' => 'an_import',
        ];

        $form['form']['submit'] = [
            'name' => 'import',
            'title' => $this->l('Import'),
        ];

        $languages = $this->context->controller->getLanguages();
  
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->name_controller = $this->name;
        $helper->submit_action = $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminProductTabs', false);
        $helper->token = Tools::getAdminTokenLite('AdminProductTabs');
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->tpl_vars = [
            'uri' => $this->module->getPathUri(),
            'languages' => $languages,
            'id_language' => $this->context->language->id
        ];

        foreach ($form['form']['input'] as $input){
            $helper->tpl_vars['fields_value'][$input['name']] = '';
        }
        
        return $helper->generateForm([$form]);
    }

    public function initToolBarTitle()
    {
        $this->toolbar_title[] = $this->l('Product Tabs: Tabs');
    }
   
    public function initHeader()
    {
        parent::initHeader();

        $id_lang = $this->context->language->id;
        $link = $this->context->link;
        $tabs = &$this->context->smarty->tpl_vars['tabs']->value;

        foreach ($tabs as &$tab0) {
            if ($tab0['class_name'] == 'IMPROVE') {
                foreach ($tab0['sub_tabs'] as &$tab1) {
                    if ($tab1['class_name'] == 'AdminParentModulesSf') {
                        
                        foreach ($tab1['sub_tabs'] as &$tab2) {
                            if ($tab2['class_name'] == 'AdminProductTabs') {
                                $sub_tabs = &$tab2['sub_tabs'];

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminProductTabs'));
                                $tab['current'] = true;
                                $tab['href'] = $link->getAdminLink('AdminProductTabs');
                                $tab['active'] = true;
                                $tab['name'] = $this->l('Tabs');
                                $sub_tabs[] = $tab;

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminProducttabsSettings'));
                                $tab['current'] = false;
                                $tab['href'] = $link->getAdminLink('AdminProducttabsSettings');
                                $tab['active'] = true;
                                $tab['name'] = $this->l('Settings');
                                $sub_tabs[] = $tab;

                                break;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
    }     
    
    public function initContent()
    {
        $this->context->smarty->assign('current_tab_level', 3);

        return parent::initContent();
    }    
    
    public function renderForm()
    {
        $this->initToolbar();
         if (!$this->loadObject(true)) {
            return;
        } 

        $this->fields_form = array(
            'tinymce' => false,
            'legend' => ['title' => $this->l('Product Tabs: Tabs')],
            'input' => [],
            'buttons' => [
                [
                    'type' => 'submit',
                    'title' => $this->l('Save'),
                    'icon' => 'process-icon-save',
                    'class' => 'pull-right',
                    'name' => 'submit'.$this->table
                ],
                [
                    'type' => 'submit',
                    'title' => $this->l('Save and stay'),
                    'icon' => 'process-icon-save',
                    'class' => 'pull-right',
                    'name' => 'submit'.$this->table.'AndStay'
                ],
            ],
        );

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'active',
            'label' => $this->l('Active'),
            'values' => [
                [
                    'id' => 'active_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'active_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];     

        $this->fields_form['input'][] = [
            'type' => 'switch',
            'name' => 'combinations',
            'label' => $this->l('Combinations'),
            'values' => [
                [
                    'id' => 'combinations_on',
                    'value' => 1,
                    'label' => $this->l('Enabled')
                ],
                [
                    'id' => 'combinations_off',
                    'value' => 0,
                    'label' => $this->l('Disabled')
                ]
            ],
        ];

        $this->fields_form['input'][] = [
            'type' => 'text',
            'name' => 'tab_name',
            'label' => $this->l('Tab name'),    
            'lang' => true,
        ];  

        $this->fields_form['input'][] = [
            'type' => 'textarea',
            'class' => 'autoload_rte',
            'name' => 'tab_content',
            'label' => $this->l('Tab content'),    
            'lang' => true,
        ];    
        
        $this->fields_form['input'][] = [
            'type' => 'radio',
            'label' => 'Relation',
            'name' => 'relation',
            'class' => 'an-sz-type-view',
            'values' => [
                [
                    'id' => 'relation_all',
                    'value' => '0',
                    'label' => $this->module->l('All'),
                ], 
                [
                    'id' => 'relation_categories',
                    'value' => '1',
                    'label' => $this->module->l('Categories')
                ], 
                [
                    'id' => 'relation_products',
                    'value' => '2',
                    'label' => $this->module->l('Products')
                ]
            ]
        ];    

        $this->fields_form['input'][] = array(
            'type' => 'inputProducts',
            'ignore' => true,
            'name' => 'productIds[]',
            'id' => 'an_sizeguide_products',
            'class' => 'js-an_sizeguide_products js-sz-block-products an_sizeguide_products',
        );

        $this->fields_form['input'][] = array(
            'type' => 'text',
            'ignore' => true,
            'label' => $this->module->l('Products'),
            'name' => 'products_input',
            'id' => 'products_input',
            'size' => 50,
            'maxlength' => 10,
            'col' => 4,
            'class' => 'js-sz-block-products',
        );

        $this->fields_value['productIds[]'] = anProductTabs::getProducsByIdTabs(Tools::getValue('id_tab'));
          
        $this->fields_form['input'][] = [
            'type'  => 'categories',
            'label' => $this->module->l('Categories'),
            'name'  => 'id_categories',
            'class' => 'js-sz-block-categories',
            'tree'  => [
                'id' => 'id_root_category',
                'use_checkbox' => true,
                'selected_categories' => anProductTabs::getRelationCategories(Tools::getValue('id_tab'))
            ]
        ];    
        
        if (Shop::isFeatureActive()) {
            $this->fields_form['input'][] = [
                'required' => true,
                'type' => 'shop',
                'label' => $this->l('Shop association'),
                'name' => 'checkBoxShopAsso',
            ];
        }
       
        return parent::renderForm();
    }

    public function processExport($text_delimiter = '"')
    {
        $tabs = anProductTabs::getAllTabs();
        // clean buffer
        if (ob_get_level() && ob_get_length() > 0) {
            ob_clean();
        }

        header('Content-Type: application/json; charset=utf8');
        header('Content-Type: application/force-download; charset=UTF-8');
        header('Cache-Control: no-store, no-cache');
        header('Content-Disposition: attachment; filename="tabs - ' . time() . '.json"');

        echo json_encode($tabs);
        die;
    }
  
    public function processSave()
    {
        if (Tools::getIsset('tab_name_' . $this->context->language->id)) {

            if (Tools::getValue('tab_name_' . $this->context->language->id) == '') {
                $this->errors[] = $this->l('Please enter a Tab name');
            }
        }

        if (!empty($this->errors)) {
            $this->display = 'edit';

            return false;
        }        
        
        $object = parent::processSave();
        
        if (isset($object->id) && $object->id) {
            
            switch (Tools::getValue('relation')){
                
                case 1:
                    $this->updateCategoriesProducts(Tools::getValue('id_categories'), $object->id, 1);
                    break;
                    
                case 2:
                    $this->updateCategoriesProducts(Tools::getValue('productIds'), $object->id, 2);
                    break;    

                default:
                    $this->updateCategoriesProducts([], $object->id, 0);
            }

        }        

        if (Tools::getIsset('submit'.$this->table.'AndStay')) {
            $this->redirect_after = $this->context->link->getAdminLink($this->controller_name).'&conf=4&updatean_productextratabs&token='.$this->token.'&id_tab='.$object->id;
        }
        
        return $object;
    }

    public function postProcess(){
        
        if (isset($_FILES['an_import']) && $_FILES['an_import']['size'] > 0) {
            
            if (_PS_MODE_DEMO_) {
                $this->errors[] = $this->module->textDemoMode;
                return false;
            }
            
            if (Tools::substr($_FILES['an_import']['name'], -5) != '.json') {
                $this->errors[] = $this->module->l(
                    'Please check the file you are trying to upload. The format is required to be JSON.'
                );
            } else {
                $data = json_decode(Tools::file_get_contents($_FILES['an_import']['tmp_name']), true);

                if(Tools::getValue('an_del_tabs') && $data){
                    Db::getInstance()->Execute('TRUNCATE TABLE `' . _DB_PREFIX_ . 'an_productextratabs`');
                    Db::getInstance()->Execute('TRUNCATE TABLE `' . _DB_PREFIX_ . 'an_productextratabs_shop`');
                    Db::getInstance()->Execute('TRUNCATE TABLE `' . _DB_PREFIX_ . 'an_productextratabs_lang`');
                    Db::getInstance()->Execute('TRUNCATE TABLE `' . _DB_PREFIX_ . 'an_productextratabs_relations`');
                }
                
                anProductTabs::importJsonAllTabs($data); 
            }
        }
            
        if (Tools::getIsset('name')) {
            
            if (!empty($this->errors)) {
                // if we have errors, we stay on the form instead of going back to the list
                $this->display = 'edit';
                return false;
            }
        }
        
        return parent::postProcess();
    }

    public function processDelete()
    {    
        $object = parent::processDelete();
        
        Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('DELETE FROM `'._DB_PREFIX_.'an_productextratabs_relations` WHERE `id_tab`='.(int) $object->id.' ');
     
        return $object;
    }  

    public function updateCategoriesProducts($ids = [], $id_tab = 0, $type = 0)
    {
        if (!$id_tab){
            return false;
        }        
        
        Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute('DELETE FROM `'._DB_PREFIX_.'an_productextratabs_relations` WHERE `id_tab`='.(int) $id_tab.' ');
        
        if (!$ids || count($ids) == 0) {
            $ids[] = 0;
        }
    
        $ids = array_unique($ids);
    
        foreach ($ids as $id) {                        
            $sql = 'INSERT INTO `'._DB_PREFIX_.'an_productextratabs_relations`  (`id_tab`, `id_type`, `type`) 
            VALUES ("'.(int) $id_tab.'", "'.(int) $id.'", "'.(int) $type.'" )';
            Db::getInstance(_PS_USE_SQL_SLAVE_)->Execute($sql);
        }
        
        return true;
    }    

    public function ajaxProcessUpdatePositions()
    {
        $status = false;
        $position = 1;
        $positions = array_map('intval', (array)Tools::getValue('positions'));
        
        foreach ($positions as $pos){
            $sql = 'UPDATE `' . _DB_PREFIX_ . $this->table .'` SET position="'.(int)$position.'" WHERE '.$this->identifier.'="'.(int)$pos.'" ';
            Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($sql);
            $position++;
        }

        $status = true;

        return $this->setJsonResponse(array(
            'success' => $status,
            'message' => $this->l($status ? 'Blocks reordered successfully' : 'An error occurred')
        ));
    }

    protected function setJsonResponse($response)
    {
        header('Content-Type: application/json; charset=utf8');
        print(json_encode($response));
        exit;
    }    

    protected function updateAssoShop($id_object)
    {
        if (!Shop::isFeatureActive()) {
            return;
        }

        $assos_data = $this->getSelectedAssoShop($this->table, $id_object);

        $exclude_ids = $assos_data;

        foreach (Db::getInstance()->executeS('SELECT id_shop FROM ' . _DB_PREFIX_ . 'shop') as $row) {
            if (!$this->context->employee->hasAuthOnShop($row['id_shop'])) {
                $exclude_ids[] = $row['id_shop'];
            }
        }

        Db::getInstance()->delete($this->table . '_shop', '`' . $this->identifier . '` = ' . (int) $id_object . ($exclude_ids ? ' AND id_shop NOT IN (' . implode(', ', $exclude_ids) . ')' : ''));

        $insert = array();

        foreach ($assos_data as $id_shop) {
            $insert[] = array(
                $this->identifier => $id_object,
                'id_shop' => (int) $id_shop,
            );
        }

        return Db::getInstance()->insert($this->table . '_shop', $insert, false, true, Db::INSERT_IGNORE);
    }

    protected function getSelectedAssoShop($table)
    {
        if (!Shop::isFeatureActive()) {
            return array();
        }

        $shops = Shop::getShops(true, null, true);

        if (count($shops) == 1 && isset($shops[0])) {
            return array($shops[0], 'shop');
        }

        $assos = array();

        if (Tools::isSubmit('checkBoxShopAsso_' . $table)) {
            foreach (Tools::getValue('checkBoxShopAsso_' . $table) as $id_shop => $value) {
                $assos[] = (int) $id_shop;
            }
        } else if (Shop::getTotalShops(false) == 1) {
            
            $assos[] = (int) Shop::getContextShopID();
        }

        return $assos;
    }      
}
