<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

class anComb 
{
    public static function productPrepare($productObj, $id_product_attribute = false,     $ajax = false)
    {
        $productObj->loadStockData();
        $product = (array)$productObj;
        
        if ($ajax){
            $product['id_product_attribute'] = $this->getIdProductAttributeByRequestOrGroup($productObj, $productObj->id);
        }
        
        if (!isset($product['id_product_attribute'])){
            $product['id_product_attribute'] = false;
        }

        if ($id_product_attribute || (!$product['id_product_attribute'] && $id_product_attribute)){
            $product['id_product_attribute'] = $id_product_attribute;
        }
        
        $product['minimal_quantity'] = anComb::getProductMinimalQuantity($productObj, $product);
        
        if (!$id_product_attribute && !$ajax ){
            $product['id_product_attribute'] = Product::getDefaultAttribute($productObj->id, $product['minimal_quantity']);
        }

        $product['images'] = $productObj->getImages(Context::getContext()->language->id);
        $product['id_product'] = (int) $productObj->id;
        $product['out_of_stock'] = (int) $productObj->out_of_stock;
        $product['new'] = (int) $productObj->new;
        $product['id_category_default'] = '';
        $product['link_rewrite'] = anComb::checkLinkRewrite($productObj->link_rewrite);
        $product['ean13'] = $productObj->ean13;
        $product['price'] = $productObj->price;
        $product['wholesale_price'] = $productObj->wholesale_price;
        $product['unit_price_ratio'] = $productObj->unit_price_ratio;
        

        $product['quantity'] = Product::getQuantity(
            (int) $productObj->id,
            (int) $product['id_product_attribute'],
            isset($product['cache_is_pack']) ? $product['cache_is_pack'] : null
        );
    
    //    $product['minimal_quantity'] = $this->getProductMinimalQuantity($productObj, $product);
        $product['quantity_wanted'] = anComb::getRequiredQuantity($productObj, $product);        
        $product['availableForOrder'] = anComb::isAvailableForOrder($product);
        
        return $product;
    }
    
    public static function getProductMinimalQuantity($product, $productArray)
    {
        $minimal_quantity = 1;
        
        if ($productArray['id_product_attribute']) {
            $combination = anComb::findProductCombinationById($product, $productArray['id_product_attribute']);
            if (isset($combination['minimal_quantity']) && $combination['minimal_quantity']) {
                $minimal_quantity = $combination['minimal_quantity'];
            }
        } else {
            $minimal_quantity = $product->minimal_quantity;
        }

        return $minimal_quantity;
    }    
    
    public static function findProductCombinationById($product, $combinationId)
    {
        $foundCombination = null;
        $combinations = $product->getAttributesGroups(Context::getContext()->language->id);
        foreach ($combinations as $combination) {
            if ((int) ($combination['id_product_attribute']) === $combinationId) {
                $foundCombination = $combination;

                break;
            }
        }

        return $foundCombination;
    }

    /**
     * Allow to check if $link_rewrite is an array or not and only return a valid value
     *
     * @param array|string $link_rewrite
     *
     * @return string
     */
    public static function checkLinkRewrite($link_rewrite)
    {
        $link_rewrite = $link_rewrite;

        if (is_array($link_rewrite)) {
            $filteredArray = array_filter($link_rewrite);
            $link_rewrite = current($filteredArray);
        }

        return $link_rewrite;
    }
    
    /**
     * @param $product
     *
     * @return int
     */
    public static function getRequiredQuantity($product, $productArray)
    {
        $requiredQuantity = (int) Tools::getValue('quantity_wanted', anComb::getProductMinimalQuantity($product, $productArray));
        if ($requiredQuantity < $productArray['minimal_quantity']) {
            $requiredQuantity = $productArray['minimal_quantity'];
        }

        return $requiredQuantity;
    }
    
    public static function isAvailableForOrder($product)
    {
        $availableForOrder = true;
        
        // If Enable stock management = off and Some Produc ->  Options -> Available for order -> off
        if (!(bool)Configuration::get('PS_STOCK_MANAGEMENT') && !$product['available_for_order']){
            return false;
        }
        
        if ((bool)Configuration::get('PS_STOCK_MANAGEMENT') && 
        !anComb::isAvailableWhenOutOfStock($product['out_of_stock']) && 
        isset($product['quantity_wanted']) && ($product['quantity'] <= 0 || $product['quantity'] < $product['quantity_wanted'])
        ){
            $availableForOrder = false;
        }

        //customizable
        //    Учесть вариант, когда костомизация заполнена
        $customization_required = false;
        if (isset($product['customizable']) && $product['customizable'] && Customization::isFeatureActive()) {
            if (count(Product::getRequiredCustomizableFieldsStatic((int)$product['id_product']))){
                $customization_required = true;
            }
        }        
        if ($customization_required){
            $availableForOrder = false;
        }

        return $availableForOrder;
    }    
    
    public static function isAvailableWhenOutOfStock($out_of_stock)
    {
        /** @TODO 1.5.0 Update of STOCK_MANAGEMENT & ORDER_OUT_OF_STOCK */
        $ps_stock_management = Configuration::get('PS_STOCK_MANAGEMENT');

        if (!$ps_stock_management) {
            return true;
        }

        $ps_order_out_of_stock = Configuration::get('PS_ORDER_OUT_OF_STOCK');

        return (int) $out_of_stock == 2 ? (int) $ps_order_out_of_stock : (int) $out_of_stock;
    }
    
    public static function attributeCombinationForSelect($attributeCombinations, $productObj)
    {
        $productsAttr = array();
        foreach ($attributeCombinations as $attributeCombination) {
            
            $product = anComb::productPrepare($productObj, $attributeCombination['id_product_attribute']);
            $prices = anComb::getPrices($productObj, $product);
            
            $productsAttr[$attributeCombination['id_product_attribute']]['availableForOrder'] = $product['availableForOrder'];
            $productsAttr[$attributeCombination['id_product_attribute']]['default_on'] = (int)$attributeCombination['default_on'];
            $productsAttr[$attributeCombination['id_product_attribute']]['prices'] = $prices;
            $productsAttr[$attributeCombination['id_product_attribute']]['comb'][] = $attributeCombination;        

            $image = Product::getCombinationImageById($attributeCombination['id_product_attribute'], Context::getContext()->language->id);
            $image_size = ImageType::getFormattedName('cart');
            
            $productsAttr[$attributeCombination['id_product_attribute']]['image']['cover'] = '';

            if ($image){
                $productsAttr[$attributeCombination['id_product_attribute']]['image']['cover'] = Context::getContext()->link->getImageLink($productObj->link_rewrite, $image['id_image'], $image_size);
            }        

            
            
            
        }
        return $productsAttr;
    }
    
    public static function getPrices($productObj, $product){
        
        $prices = array();
        $taxConfiguration = new TaxConfiguration();        
        if ($taxConfiguration->includeTaxes()) {
            $price = $productObj->getPrice(true, $product['id_product_attribute'], 2);
            $prices['regular_price_amount'] = $productObj->getPriceWithoutReduct(true, $product['id_product_attribute'], 2);
        } else {
            $price = $productObj->getPrice(false, $product['id_product_attribute'], 2);
            $prices['regular_price_amount'] = $productObj->getPriceWithoutReduct(false, $product['id_product_attribute'], 2);
        }

        $productProperties = Product::getProductProperties(Context::getContext()->language->id, $product, Context::getContext());

        if ($productProperties['specific_prices']) {
             $prices['has_discount'] = (0 != $productProperties['reduction']);
            $prices['discount_type'] = $productProperties['specific_prices']['reduction_type'];
            $prices['discount_percentage'] = -round(100 * $productProperties['specific_prices']['reduction']).'%';
            $prices['discount_percentage_absolute'] = round(100 * $productProperties['specific_prices']['reduction']).'%';
            $prices['discount_amount'] = Tools::displayPrice($productProperties['reduction']);
            $prices['regular_price'] = Tools::displayPrice($productProperties['price_without_reduction']); 
        }
        
        $prices['price_amount'] = $price;
        $prices['price'] = Tools::displayPrice($price); 
        
        return $prices;
    }
}
 
 
 
?>