<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

class anHomeSliders extends ObjectModel
{
      /**
     * @var int
     */
    public $id_slider;
    /**
     * @var int
     */
    public $id;
    /**
     * @var int
     */
    public $active = 1;
    
    public $title_slider;
    public $hook;

    public $preloader = 1;

    public $preloader_height_1920 = 500;
    public $preloader_height_1600 = 500;
    public $preloader_height_1366 = 500;
    public $preloader_height_991 = 300;
    public $preloader_height_767 = 300;

    public $lazy_load = 1;

    public $loop = 1;
    public $nav = 1;
    public $dots = 1;
    public $autoplay = 1;

    public $smartspeed = 1000;

    public $autoplay_timeout = 5000;

    public $responsive_image = 1;

    public $show_on;
    public $show_content_on;
    /**
     * @var array
     */
    public static $definition = [
        'table' => 'an_homeslider_sliders',
        'primary' => 'id_slider',
        'multilang' => true,
        'fields' => [
            
            'id_slider' => ['type' =>self::TYPE_INT ],
            'active' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'title_slider' => ['type' =>self::TYPE_STRING, 'lang' => true ],
            'hook' => ['type' =>self::TYPE_STRING],

            'preloader' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],

            'preloader_height_1920' => ['type' =>self::TYPE_INT ],
            'preloader_height_1600' => ['type' =>self::TYPE_INT ],
            'preloader_height_1366' => ['type' =>self::TYPE_INT ],
            'preloader_height_991' => ['type' =>self::TYPE_INT ],
            'preloader_height_767' => ['type' =>self::TYPE_INT ],

            'lazy_load' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],

            'loop' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'nav' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'dots' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],
            'autoplay' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],

            'smartspeed' => ['type' =>self::TYPE_INT ],

            'autoplay_timeout' => ['type' =>self::TYPE_INT ],

            'responsive_image' => ['type' => self::TYPE_BOOL, 'validate' => 'isBool'],

            'show_on' => ['type' =>self::TYPE_INT ],
            'show_content_on' => ['type' =>self::TYPE_INT ], 
        ],
    ];

    public const fileJsonSlider = _PS_MODULE_DIR_ . 'an_homeslider/sliders.json';

    /**
     * Formula constructor.
     *
     * @param null $id
     */
    public function __construct($id = null, $id_lang = null)
    {
        parent::__construct($id, $id_lang);
    }

    public static function getSliders($hookName = '', $pathImg = true, $allShops = false)
    {
		$sql = '
		SELECT * FROM `' . _DB_PREFIX_ . 'an_homeslider_sliders` sw
		LEFT JOIN `' . _DB_PREFIX_ . 'an_homeslider_sliders_lang` sl 
			ON (sw.`id_slider` = sl.`id_slider`
            AND sl.`id_lang` = ' . (int) Context::getContext()->language->id . ')
		WHERE sw.`active`=1
		';	

        if ($hookName != 'all') {
            $sql .= 'AND sw.`hook` = "'.pSQL($hookName).'"';
        }

		if (Shop::isFeatureActive() && !$allShops) {
			$sql .= ' AND sw.`id_slider` IN (
				SELECT hs.`id_slider`
				FROM `' . _DB_PREFIX_ . 'an_homeslider_sliders_shop` hs
				WHERE hs.id_shop IN (' . implode(', ', Shop::getContextListShopID()) . ')
			)';
		}	
		
		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($sql);  

        foreach ($result as $id => $item) {
            $result[$id]['slides'] = anHomeSlides::getSlides($item['id_slider'], $pathImg, $allShops);
        }

        return $result;
    }

    public static function exportJsonSliders()
	{
		$sliders = self::getSliders('all', false);	
		@file_put_contents(self::fileJsonSlider, json_encode($sliders));
	}	

	public static function importJsonSliders()
	{
		$data = json_decode(Tools::file_get_contents(self::fileJsonSlider), true);
		$context = Context::getContext();
        
		if ($data){
			
			foreach ($data as $item){
                
				$sliderObj = new anHomeSliders();
				$sliderObj->id_slider = $item['id_slider'];

				$sliderObj->active = $item['active'];
                $sliderObj->hook = $item['hook'];

                $sliderObj->preloader = $item['preloader'];

                $sliderObj->preloader_height_1920 = $item['preloader_height_1920'];
                $sliderObj->preloader_height_1600 = $item['preloader_height_1600'];
                $sliderObj->preloader_height_1366 = $item['preloader_height_1366'];
                $sliderObj->preloader_height_991 = $item['preloader_height_991'];
                $sliderObj->preloader_height_767 = $item['preloader_height_767'];

                $sliderObj->lazy_load = $item['lazy_load'];

                $sliderObj->loop = $item['loop'];
                $sliderObj->nav = $item['nav'];
                $sliderObj->dots = $item['dots'];
                $sliderObj->autoplay = $item['autoplay'];

                $sliderObj->smartspeed = $item['smartspeed'];

                $sliderObj->autoplay_timeout = $item['autoplay_timeout'];

                $sliderObj->responsive_image = $item['responsive_image'];

                $sliderObj->show_on = $item['show_on'];
                $sliderObj->show_content_on = $item['show_content_on'];

				$languages = Language::getLanguages();
				foreach ($languages as $language) {
					$sliderObj->title_slider[$language['id_lang']] = $item['title_slider'];
				}				
				$sliderObj->save();
			}
		}
	}    
}