<?php
/**
 * 2022 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2022 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

require_once _PS_MODULE_DIR_ . 'an_homeslider/classes/anHomeSlides.php';
require_once _PS_MODULE_DIR_ . 'an_homeslider/classes/anHomeSliders.php';

require_once _PS_MODULE_DIR_ . 'an_homeslider/hooks_ignore.php';

class an_homeslider extends Module implements WidgetInterface
{

	const PREFIX = 'an_hs_';
	
    protected $_tabs = [			
        
        [
            'class_name' => 'AdminAnhomeSlides',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Slides',
			'active' => 0
        ],	 
        
        [
            'class_name' => 'AdminAnhomeSliders',
            'parent' => 'AdminParentModulesSf',
            'name' => 'Slider',
			'active' => 0
        ],	
    ];	

    public function __construct()
    {
        $this->name = 'an_homeslider';
        $this->tab = 'others';
        $this->version = '1.0.3';
        $this->author = 'Anvanto';
        $this->need_instance = 0;

        $this->bootstrap = true;
        $this->module_key = '';

        parent::__construct();

        $this->displayName = $this->l('Home Slider');
        $this->description = $this->l('Home Slider');

        $this->confirmUninstall = $this->l('Are you sure you want to uninstall the module?');

        $this->ps_versions_compliancy = array('min' => '1.7', 'max' => _PS_VERSION_);

        $this->templateFile['widget'] = '/views/templates/front/widget.tpl';  
    }

    /**
     * @return bool
     */
    public function install()
    {
		$sql = include _PS_MODULE_DIR_ . $this->name . '/sql/install.php';
		foreach ($sql as $_sql) {
			Db::getInstance()->Execute($_sql);
		} 
			
		$languages = Language::getLanguages();
		foreach ($this->_tabs as $tab) {
			$_tab = new Tab();
			$_tab->active = $tab['active'];
			$_tab->class_name = $tab['class_name'];
			$_tab->id_parent = Tab::getIdFromClassName($tab['parent']);
			if (empty($_tab->id_parent)) {
				$_tab->id_parent = 0;
			}

			$_tab->module = $this->name;
			foreach ($languages as $language) {
				$_tab->name[$language['id_lang']] = $this->l($tab['name']);
			}

			$_tab->add();
		}

        anHomeSlides::importJsonSlides();
        anHomeSliders::importJsonSliders();
        $this->setDefaultForAllShops();

        return parent::install()
            && $this->registerHook('displayHeader'); 
           
    }

    /**
     * @return bool
     */

    public function uninstall()
    {
 		$sql = include _PS_MODULE_DIR_ . $this->name .  '/sql/uninstall.php';
		foreach ($sql as $_sql) {
			Db::getInstance()->Execute($_sql);
		} 	
		
		foreach ($this->_tabs as $tab) {
			$_tab_id = Tab::getIdFromClassName($tab['class_name']);
			$_tab = new Tab($_tab_id);
			$_tab->delete();
		}		

        return parent::uninstall();
    }

    /**
     * @param $hookName
     * @param array $params
     * @return mixed|void
     */

    public function setDefaultForAllShops()
	{
		if (!Shop::isFeatureActive()) {
			return false;
		}

		$shops = Shop::getShops(true, null, true);
		$allSliders = anHomeSliders::getSliders('all', false, true);
		//echo '<pre>'; var_dump($allSliders); die;
		foreach ($shops as $shop){
			foreach ($allSliders as $slider){
                Db::getInstance()->insert('an_homeslider_sliders_shop', ['id_slider' => (int) $slider['id_slider'], 'id_shop' => (int) $shop]);
                    foreach ($slider['slides'] as $slide){
                        Db::getInstance()->insert('an_homeslider_slides_shop', ['id_slide' => (int) $slide['id_slide'], 'id_shop' => (int) $shop]);
                    }
			}
		}

		return true;
	}

    public function renderWidget($hookName, array $params)
    {
        $widget = $this->getWidgetVariables($hookName, $params);
        $this->smarty->assign('widget', $widget);
        return $this->fetch('module:' . $this->name . '/views/templates/front/widget.tpl');
    }

    /**
     * @param $hookName
     * @param array $params
     * @return array
     */
    
    public function getWidgetVariables($hookName, array $params)
    {		
        return anHomeSliders::getSliders($hookName);
    }

    public function getFormatFile($fileName) 
    {
        $uploadImageName = trim(strip_tags($fileName));
        return pathinfo($uploadImageName, PATHINFO_EXTENSION);
    }

    public function getHooksList($file = 'hooks')
    {
        if (Tools::file_exists_no_cache(_PS_MODULE_DIR_ . 'an_homeslider/'.$file.'.php')) {
            return include _PS_MODULE_DIR_ . 'an_homeslider/'.$file.'.php';
        } else {
            return array();
        }
    }
	
    /**
     * @return bool
     */
	
    public function hookFilter($hook)
    {
        $res = strpos(Tools::strtolower($hook['name']), 'admin') === false;
        $res &= strpos(Tools::strtolower($hook['name']), 'backoffice') === false;
		
		$ignoreHooks = $this->getHooksList('hooks_ignore');
		if (in_array($hook['name'], $ignoreHooks)){
			 $res &= false;
		}
	
        return $res;
    }
	
    /**
     * @return array
     */
    public function getHooksQuery()
    {
        $hooksQuery = array();

        $hooks = Hook::getHooks(true, true);
        $prestaHooks = array_filter($hooks, array($this, 'hookFilter'));
		
		if (version_compare(_PS_VERSION_, '1.7.0.0', '<') == 1) {
			foreach ($this->getHooksList() as $hookname) {
				$hooksQuery[] = array('name' => $hookname);
			}
			
			return array_merge($hooksQuery);
		} else {
			foreach ($this->getHooksList() as $hookname) {
				if (!in_array($hookname, array_column($prestaHooks, 'name'))) {
					$hooksQuery[] = array('name' => $hookname);
				}
			}
			
			return array_merge($hooksQuery, $prestaHooks);
		}
    }
	
	public function getContent()
	{
        Tools::redirectAdmin($this->context->link->getAdminLink('AdminAnhomeSliders'));
	}

    public function hookHeader()
    {
        $this->hookDisplayHeader();
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->addJquery();  
            
        $this->context->controller->registerStylesheet(
            $this->name . "_css_carusel",
            $this->getCSJSFilePath('owl.carousel.min.css'),
            ['server' => 'local', 'priority' => 150]
        );

        $this->context->controller->registerJavascript(
            $this->name . "_js_carusel",
            $this->getCSJSFilePath('owl.carousel.min.js'),
            array('server' => 'local', 'priority' => 150)
        ); 

        $this->context->controller->registerJavascript(
            $this->name . "_js_init_slider",
            'modules/' . $this->name . '/views/js/init.slider.js',
            array('server' => 'local', 'priority' => 150)
        );

		$this->context->controller->registerStylesheet(
            $this->name . "_css",
            'modules/' . $this->name . '/views/css/front.css',
            ['server' => 'local', 'priority' => 150]
        );

    }

    public function getCSJSFilePath($file = '')
    {
        if ($file == ''){
            return false;
        }

        $ex = explode('.', $file);
        $fileType = end($ex);
        
        if (Tools::file_exists_no_cache(_PS_THEME_DIR_.'/assets/lib/' . $file)){
            $path = 'themes/'._THEME_NAME_.'/assets/lib/' . $file;   
        } else if (Tools::file_exists_no_cache('modules/anthemeblocks/views/' . $fileType . '/' . $file)){
            $path = 'modules/anthemeblocks/views/' . $fileType . '/' . $file; 
        } else {    
            $path = 'modules/' . $this->name . '/views/' . $fileType . '/' . $file;      
        } 

        return $path;
    }
    
	public function topPromo()
	{		
		$this->context->smarty->assign('theme', $this->getThemeInfo());
        return $this->display(__FILE__, 'views/templates/admin/top.tpl');
	}
	
	public function getThemeInfo()
	{
		$theme = [];
		$themeFileJson = _PS_THEME_DIR_.'/config/theme.json';
		if (Tools::file_exists_no_cache($themeFileJson)) {
			$theme = (array)json_decode(Tools::file_get_contents($themeFileJson), 1);			
		}

		if (!isset($theme['url_contact_us']) || $theme['url_contact_us'] == ''){
			
			$urlContactUs = 'https://addons.prestashop.com/contact-form.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlContactUs .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_contact_us) && $this->url_contact_us != ''){
				$urlContactUs = $this->url_contact_us;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlContactUs .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_contact_us'] = $urlContactUs;
		}
		
		if (!isset($theme['url_rate']) || $theme['url_rate'] == ''){
			
			$urlRate = 'https://addons.prestashop.com/ratings.php';

			if (isset($theme['addons_id']) && $theme['addons_id'] != ''){
				$urlRate .= '?id_product=' .$theme['addons_id'];
			} elseif (isset($this->url_rate) && $this->url_rate != ''){
				$urlRate = $this->url_rate;
			} elseif (isset($this->addons_product_id) && $this->addons_product_id != ''){
				$urlRate .= '?id_product=' .$this->addons_product_id;
			}
			
			$theme['url_rate'] = $urlRate;
		}		
		
		return $theme;
	}
}
