<?php
/**
 * 2021 Anvanto
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 wesite only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 *  @author Anvanto <anvantoco@gmail.com>
 *  @copyright  2021 Anvanto
 *  @license    Valid for 1 website (or project) for each purchase of license
 *  International Registered Trademark & Property of Anvanto
 */

require_once _PS_MODULE_DIR_ . 'an_homeproducts/classes/anHomeProductsBlocks.php';

class AdminAnhomeproductsSettingsController extends ModuleAdminController
{
    protected $_module = null;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->display = 'view';
 
		$this->name = 'AdminAnhomeproductsSettingsController';
		
        parent::__construct();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJquery();
        $this->js_files[] = _MODULE_DIR_ . 'an_homeproducts/views/js/back_settings.js';
    } 

    public function initToolBarTitle()
    {
        $this->toolbar_title[] = $this->module->l('Home Products: Settings');
    }

    public function initHeader()
    {
        parent::initHeader();

        $id_lang = $this->context->language->id;
        $link = $this->context->link;
        $tabs = &$this->context->smarty->tpl_vars['tabs']->value;

        foreach ($tabs as &$tab0) {
            if ($tab0['class_name'] == 'IMPROVE') {
                foreach ($tab0['sub_tabs'] as &$tab1) {
                    if ($tab1['class_name'] == 'AdminParentModulesSf') {
						
                        foreach ($tab1['sub_tabs'] as &$tab2) {
                            if ($tab2['class_name'] == 'AdminAnhomeproductsSettings') {
                                $sub_tabs = &$tab2['sub_tabs'];

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnhomeproductsBlocks'));
                                $tab['current'] = false;
                                $tab['href'] = $link->getAdminLink('AdminAnhomeproductsBlocks');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab;

                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnhomeproductsBanners'));
                                $tab['current'] = false;
                                $tab['href'] = $link->getAdminLink('AdminAnhomeproductsBanners');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab;                                
                                
                                $tab = Tab::getTab($id_lang, Tab::getIdFromClassName('AdminAnhomeproductsSettings'));
                                $tab['current'] = true;
                                $tab['href'] = $link->getAdminLink('AdminAnhomeproductsSettings');
                                $tab['active'] = true;
                                $sub_tabs[] = $tab;
                                
                                break;
                            }
                        }
                        break;
                    }
                }
                break;
            }
        }
    }	
	
    public function initContent()
    {
        $this->context->smarty->assign('current_tab_level', 3);

        return parent::initContent();
    }    
	
	
    /**
     * Create the structure of your form.
     */
    protected function getSettingsForm()
    {
        $form['form']['legend'] = [
            'title' => $this->l('Settings'),
        ];
    
        $form['form']['submit'] = [
            'name' => 'save',
            'title' => $this->l('Save'),
        ];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'use_cache',
			'label' => $this->l('Use cache'),
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
            'form_group_class' => 'hide',
		];

        $form['form']['input'][] = [
			'type' => 'radio',
			'label' => $this->l('Type view'),
			'name' => an_homeproducts::PREFIX . 'view_type',
			'values' => [
				[
					'id' => 'blocks',
					'value' => 'blocks',
					'label' => $this->l('Blocks')
				],
				[
					'id' => 'tabs',
					'value' => 'tabs',
					'label' => $this->l('Tabs'),
				],            
			],
        ];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'slider',
			'label' => $this->l('Slider'),
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'slider_nav',
			'label' => $this->l('Slider Nav'),
            'form_group_class' => 'js-hp-setting-slider-option',
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'slider_dots',
			'label' => $this->l('Slider Dots'),
            'form_group_class' => 'js-hp-setting-slider-option',
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'slider_loop',
			'label' => $this->l('Slider Loop'),
            'form_group_class' => 'js-hp-setting-slider-option',
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

		$form['form']['input'][] = [
			'type' => 'switch',
			'name' => an_homeproducts::PREFIX . 'show_load_more',
			'label' => $this->l('Show "Load more"'),
            'form_group_class' => 'js-hp-setting-load_more',
			'values' => [
				[
					'id' => 'active_on',
					'value' => 1,
					'label' => $this->l('Enabled')
				],
				[
					'id' => 'active_off',
					'value' => 0,
					'label' => $this->l('Disabled')
                ]
			],
		];

        $form['form']['input'][] = [
            'type' => 'text',
            'label' => $this->l('Title'),
            'name' => an_homeproducts::PREFIX . 'title',
            'lang' => true,
        ];

        $form['form']['input'][] = [
			'type' => 'textarea',
			'class' => 'autoload_rte',
			'name' => an_homeproducts::PREFIX . 'text',
			'label' => $this->l('Text'),	
            'lang' => true,
            'html' => true,
        ];



        return $form;
    }

    public function renderView()
    {
        $languages = $this->context->controller->getLanguages();
  
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->name_controller = $this->name;
        $helper->submit_action = $this->name;
        $helper->currentIndex = $this->context->link->getAdminLink('AdminAnhomeproductsSettings', false);
        $helper->token = Tools::getAdminTokenLite('AdminAnhomeproductsSettings');
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->tpl_vars = [
            'uri' => $this->module->getPathUri(),
            'languages' => $languages,
            'id_language' => $this->context->language->id
        ];

        $form = $this->getSettingsForm();

        
        foreach ($form['form']['input'] as $input){
            if (isset($input['lang']) && $input['lang']){
                $value = [];
                foreach ($languages  as $language){
                    $value[$language['id_lang']] = Configuration::get($input['name'], $language['id_lang']);
                }
                $helper->tpl_vars['fields_value'][$input['name']] = $value;
            } else {
                $helper->tpl_vars['fields_value'][$input['name']] = Configuration::get($input['name']);
            }
        }
        	
        return $helper->generateForm([$form]);		
	}

    public function postProcess()
    {    
        $form = $this->getSettingsForm();
        
        if (Tools::isSubmit($form['form']['submit']['name'])) {

            $languages = Language::getLanguages(false);
            
            foreach ($form['form']['input'] as $input){

                $html = false;
                if (isset($input['html']) && $input['html']){
                    $html = true;
                }

                if (isset($input['lang']) && $input['lang']){
                    $value = [];
                    foreach ($languages  as $language){
                        $value[$language['id_lang']] = Tools::getValue($input['name'].'_' . $language['id_lang']);
                    }
        
                    Configuration::updateValue($input['name'], $value, $html);
                } else {
                    Configuration::updateValue($input['name'], Tools::getValue($input['name']), $html);
                }
            }

            $this->module->_clearCache('*');

            $currentIndex = $this->context->link->getAdminLink('AdminAnhomeproductsSettings', false);
            $token = Tools::getAdminTokenLite('AdminAnhomeproductsSettings');            
            Tools::redirectAdmin($currentIndex . '&token=' . $token . '&conf=4');
        }
		return true;
    }
}
