{*
* 2022 Anvanto
*
* NOTICE OF LICENSE
*
* This file is not open source! Each license that you purchased is only available for 1 wesite only.
* If you want to use this file on more websites (or projects), you need to purchase additional licenses. 
* You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
*
*  @author Anvanto <anvantoco@gmail.com>
*  @copyright  2022 Anvanto
*  @license    Valid for 1 website (or project) for each purchase of license
*  International Registered Trademark & Property of Anvanto
*}

{extends file="helpers/form/form.tpl"}

{block name="input"}
	{if $input.type == 'number'}	
	<input type="number"
		id="{if isset($input.id)}{$input.id}{else}{$input.name}{/if}"
		name="{$input.name}"
		class="form-control {if isset($input.class)} {$input.class} {/if}"
		onkeyup="return (function (el, e) {
			if (e.keyCode == 8) return true;
			jQuery(el).val((parseInt(jQuery(el).val()) || 0));
			if (jQuery(el).val() < (parseInt(jQuery(el).attr('min')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('min')) || 0));
			} else if (jQuery(el).val() > (parseInt(jQuery(el).attr('max')) || 0)) {
				jQuery(el).val((parseInt(jQuery(el).attr('max')) || 0));
			}
		})(this, event);"
		value="{$fields_value[$input.name]|escape:'html':'UTF-8'}"
		{if isset($input.size)} size="{$input.size}"{/if}
		{if isset($input.maxchar) && $input.maxchar} data-maxchar="{$input.maxchar|intval}"{/if}
		{if isset($input.maxlength) && $input.maxlength} maxlength="{$input.maxlength|intval}"{/if}
		{if isset($input.readonly) && $input.readonly} readonly="readonly"{/if}
		{if isset($input.disabled) && $input.disabled} disabled="disabled"{/if}
		{if isset($input.autocomplete) && !$input.autocomplete} autocomplete="off"{/if}
		{if isset($input.required) && $input.required} required="required" {/if}
		{if isset($input.max)} max="{$input.max|intval}"{/if}
		{if isset($input.min)} min="{$input.min|intval}"{/if}
		{if isset($input.placeholder) && $input.placeholder} placeholder="{$input.placeholder}"{/if} />
		{if isset($input.suffix)}
		<span class="input-group-addon">
			{$input.suffix}
		</span>
		{/if}	
	{elseif $input.type == 'html'}
		{if isset($input.html_content)}
			{if $input.html_content == 'hr'}
			<hr />
			{else}
			{$input.html_content}
			{/if}
		{else}
			{$input.name|escape:'htmlall':'UTF-8'}
		{/if}
	{else}	
		{$smarty.block.parent}
		{if $input.type == 'file'}
		<div class="form-group">
			<div class="col-lg-8">		
				<a class="btn btn-default advantages-del-img-bt"><i class="icon-trash"></i>{l s='Delete' mod='an_advantages'}</a>	
				<input class ="advantages-input-del" type = "hidden" name = "image_delete" id = "image_del" value = "0">
			</div>
		</div>
		{/if}
    {/if}
{/block}